-- Migration: Add adaptive position sizing statistics to backtest_results
-- Implements Requirements 9.3, 9.4, 9.5: 在回测报告中添加调整次数统计、调整比例分布、平均调整比例

-- Add position_adjustments column (仓位调整次数)
ALTER TABLE backtest_results ADD COLUMN position_adjustments INTEGER DEFAULT 0;

-- Add average_adjustment_ratio column (平均调整比例)
ALTER TABLE backtest_results ADD COLUMN average_adjustment_ratio REAL DEFAULT 0;

-- Add adjustment_ratios column (调整比例分布，存储为JSON数组)
ALTER TABLE backtest_results ADD COLUMN adjustment_ratios TEXT DEFAULT '[]';

-- Create index for querying backtest results with adjustments
CREATE INDEX IF NOT EXISTS idx_backtest_results_adjustments ON backtest_results(position_adjustments);
