-- Migration: Disable unconfigured default AI models
-- Date: 2025-11-27
-- Description: Disable or delete AI models that have empty API keys
-- This migration ensures that only properly configured AI models are available to users
-- Requirements: 2.1 - System SHALL NOT automatically create default AI models with empty API keys

-- Option 1: Disable all models with empty API keys (safer approach)
-- This preserves the model records but prevents them from being used
UPDATE ai_models 
SET enabled = 0 
WHERE api_key = '' OR api_key IS NULL;

-- Option 2: Delete default models that are not configured
-- This removes system-created default models that were never configured by users
DELETE FROM ai_models 
WHERE user_id = 'default' 
  AND (api_key = '' OR api_key IS NULL);

-- Log the migration result
SELECT 'Migration 007 completed: Disabled/deleted unconfigured AI models' as status;
