-- Migration: Add AI model selection to learning sessions
-- Date: 2024-01-25
-- Description: Adds model_id and last_model_id columns to learning_sessions table for per-session AI model selection

-- Add model_id column to learning_sessions
-- This stores the AI model currently used by the session
ALTER TABLE learning_sessions ADD COLUMN model_id TEXT DEFAULT '';

-- Add last_model_id column to learning_sessions
-- This stores the user's last used model for preference memory
ALTER TABLE learning_sessions ADD COLUMN last_model_id TEXT DEFAULT '';

-- Create index for faster model lookups
CREATE INDEX IF NOT EXISTS idx_learning_sessions_model ON learning_sessions(model_id);

-- Update existing sessions to use default model (first enabled model for each user)
-- This ensures backward compatibility for existing sessions
UPDATE learning_sessions 
SET model_id = (
    SELECT id FROM ai_models 
    WHERE user_id = learning_sessions.user_id 
    AND enabled = 1 
    LIMIT 1
)
WHERE model_id = '' OR model_id IS NULL;

-- Verify migration completed
SELECT 'Migration completed: AI model selection columns added to learning_sessions' as status;
