-- Migration: Create margin_violations table
-- Purpose: Track AI margin awareness violations for monitoring and feedback
-- Requirements: 5.1, 5.2

-- Create margin_violations table
CREATE TABLE IF NOT EXISTS margin_violations (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    timestamp DATETIME NOT NULL,
    session_id TEXT,
    required_margin REAL NOT NULL,
    available_margin REAL NOT NULL,
    gap_amount REAL NOT NULL,
    decision_count INTEGER NOT NULL,
    ai_model TEXT,
    prompt_template TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Create indexes for efficient querying
CREATE INDEX IF NOT EXISTS idx_margin_violations_timestamp ON margin_violations(timestamp);
CREATE INDEX IF NOT EXISTS idx_margin_violations_session ON margin_violations(session_id);

SELECT 'Migration completed: margin_violations table created' as status;
