-- Migration: Add leverage configuration to backtest configs
-- Date: 2024-12-07
-- Description: Adds btc_eth_leverage and altcoin_leverage columns to backtest_configs table for configurable leverage settings
-- Requirements: 1.1, 1.2, 1.4

-- Add btc_eth_leverage column to backtest_configs
-- This stores the maximum leverage for BTC and ETH trading pairs
-- Default value: 10x (Requirements 1.2, 1.4)
ALTER TABLE backtest_configs ADD COLUMN btc_eth_leverage INTEGER DEFAULT 10;

-- Add altcoin_leverage column to backtest_configs  
-- This stores the maximum leverage for altcoin trading pairs
-- Default value: 5x (Requirements 1.2, 1.4)
ALTER TABLE backtest_configs ADD COLUMN altcoin_leverage INTEGER DEFAULT 5;

-- Verify migration completed
SELECT 'Migration completed: leverage configuration columns added to backtest_configs' as status;
