# AI扫描间隔说明

## 什么是扫描间隔？

扫描间隔是AI交易员分析市场并做出交易决策的时间间隔。例如，设置为15分钟，AI会每15分钟分析一次市场数据，并决定是否需要开仓、平仓或调整仓位。

## 扫描间隔的影响

### 短间隔（5-15分钟）
**优点**：
- 更快响应市场变化
- 捕捉短期交易机会
- 适合高频交易策略

**缺点**：
- API调用频率高，可能触发交易所限频
- 增加交易成本（手续费）
- 可能产生过度交易
- 对AI模型API配额消耗大

### 中等间隔（15-30分钟）⭐ 推荐
**优点**：
- 平衡响应速度和稳定性
- 避免过度交易
- 降低API调用成本
- 适合大多数交易策略

**缺点**：
- 可能错过极短期机会
- 需要更好的趋势判断

### 长间隔（30-60分钟）
**优点**：
- 关注中长期趋势
- 减少交易频率和成本
- 降低API使用量
- 更稳定的交易策略

**缺点**：
- 响应市场变化较慢
- 可能错过短期机会
- 需要更大的止损空间

## 推荐设置

### 根据交易风格选择

#### 日内交易
- **推荐间隔**：15-20分钟
- **特点**：关注日内波动，快速进出
- **适合**：波动较大的市场

#### 波段交易
- **推荐间隔**：30-45分钟
- **特点**：捕捉中期趋势
- **适合**：趋势明确的市场

#### 趋势跟踪
- **推荐间隔**：45-60分钟
- **特点**：跟随长期趋势
- **适合**：稳定上涨或下跌的市场

### 根据市场状况调整

#### 高波动市场
- 建议：15-20分钟
- 原因：需要快速响应价格变化

#### 低波动市场
- 建议：30-60分钟
- 原因：减少无效交易，降低成本

#### 趋势市场
- 建议：30-45分钟
- 原因：给趋势足够的发展时间

#### 震荡市场
- 建议：45-60分钟
- 原因：避免频繁交易，减少假信号

## 交易所限频说明

### 什么是API限频？
交易所为了保护系统稳定性，会限制API调用频率。如果超过限制，您的请求可能被拒绝或账户被暂时封禁。

### 常见交易所限制

#### Binance
- 订单限制：10次/秒
- 权重限制：1200/分钟
- 建议最小间隔：15分钟

#### Hyperliquid
- 请求限制：100次/分钟
- 建议最小间隔：10分钟

### 避免限频的建议
1. 不要设置过短的扫描间隔（< 10分钟）
2. 避免同时运行多个交易员
3. 监控API使用情况
4. 如遇限频，适当增加间隔

## AI模型配额考虑

### API调用成本
每次扫描都会调用AI模型API，产生费用：
- **短间隔**：每天96-288次调用（5-15分钟）
- **中等间隔**：每天48-96次调用（15-30分钟）
- **长间隔**：每天24-48次调用（30-60分钟）

### 配额管理建议
1. 根据会员等级选择合适间隔
2. 监控每日API使用量
3. 优化提示词，提高决策质量
4. 考虑使用更高效的AI模型

## 如何设置扫描间隔

1. 打开AI交易员配置
2. 找到"AI扫描间隔"设置
3. 输入间隔时间（分钟）
4. 查看下方的建议提示
5. 保存配置

## 动态调整策略

### 市场开盘时段
- 建议：15-20分钟
- 原因：开盘波动大，需要快速响应

### 市场平稳时段
- 建议：30-45分钟
- 原因：减少无效交易

### 重大新闻前后
- 建议：临时降低到10-15分钟
- 原因：市场可能剧烈波动

### 周末或假期
- 建议：增加到45-60分钟
- 原因：交易量低，波动小

## 性能监控

### 关键指标
- **交易频率**：每天开仓次数
- **胜率**：盈利交易占比
- **平均持仓时间**：每笔交易的持续时间
- **API使用量**：每日调用次数

### 优化建议
如果发现：
- 交易过于频繁 → 增加扫描间隔
- 错过明显机会 → 减少扫描间隔
- API配额不足 → 增加扫描间隔
- 胜率低 → 调整间隔或优化策略

## 常见问题

### Q: 可以设置小于5分钟的间隔吗？
A: 技术上可以，但强烈不建议。这会导致：
- 触发交易所限频
- 快速消耗AI配额
- 产生大量交易手续费
- 可能导致过度交易

### Q: 不同币种可以设置不同间隔吗？
A: 目前一个交易员使用统一的扫描间隔。如需不同间隔，可以创建多个交易员。

### Q: 扫描间隔会影响止损吗？
A: 不会。止损是实时监控的，不受扫描间隔影响。

### Q: 如何知道当前设置是否合适？
A: 观察以下指标：
- 交易频率是否合理
- 是否频繁触发限频
- AI配额使用是否在预算内
- 交易表现是否符合预期

## 最佳实践

1. **从推荐值开始**：新手建议从15-30分钟开始
2. **逐步优化**：根据实际表现调整
3. **监控成本**：关注API和手续费成本
4. **避免极端值**：不要设置过短或过长的间隔
5. **记录数据**：记录不同间隔下的表现，找到最优值

## 风险提示

⚠️ **注意事项**：
- 过短的间隔可能导致账户被交易所限制
- 频繁交易会增加手续费成本
- 快速消耗AI模型配额
- 建议从15分钟开始，根据实际情况调整

## 相关文档

- [AI模型配置](../ai-models/model-selection.md)
- [交易策略优化](../best-practices/strategy-optimization.md)
- [成本控制指南](../best-practices/cost-management.md)
