﻿# 保证金模式说明

## 什么是保证金模式？

保证金模式决定了您的仓位如何使用账户资金。灵耀AI支持两种保证金模式：全仓模式和逐仓模式。

## 全仓模式（Cross Margin）

全仓模式下，所有仓位共享账户的全部可用保证金。

### 优点
- **资金利用率高**：所有仓位可以共享账户余额，提高资金使用效率
- **不容易被强平**：当某个仓位出现亏损时，可以使用账户其他资金来维持仓位
- **适合多币种交易**：多个仓位可以相互支撑

### 缺点
- **风险较高**：一个仓位的大幅亏损可能影响整个账户
- **连锁反应**：如果账户总保证金不足，所有仓位都可能被强平
- **风险管理复杂**：需要整体考虑所有仓位的风险

### 适用场景
- 经验丰富的交易者
- 需要高资金利用率的策略
- 多币种分散投资

## 逐仓模式（Isolated Margin）

逐仓模式下，每个仓位使用独立的保证金，仓位之间互不影响。

### 优点
- **风险隔离**：单个仓位爆仓不会影响其他仓位和账户余额
- **风险可控**：每个仓位的最大损失是该仓位的保证金
- **适合高风险交易**：可以用小额资金测试高风险策略

### 缺点
- **资金利用率较低**：需要为每个仓位单独分配保证金
- **容易被强平**：单个仓位无法使用账户其他资金
- **需要手动调整**：需要为每个仓位单独管理保证金

### 适用场景
- 新手交易者
- 测试新策略
- 高风险单币种交易

## 如何选择？

### 选择全仓模式，如果您：
- 有丰富的交易经验
- 需要最大化资金利用率
- 进行多币种分散投资
- 有完善的风险管理策略

### 选择逐仓模式，如果您：
- 刚开始使用AI交易
- 想要严格控制每笔交易的风险
- 测试新的交易策略
- 进行高杠杆交易

## 在灵耀AI中设置

在创建或编辑AI交易员时，您可以选择保证金模式：

1. 打开交易员配置页面
2. 找到"保证金模式"选项
3. 选择"全仓"或"逐仓"
4. 保存配置

**注意**：保证金模式一旦设置，建议不要频繁更改，因为这会影响AI的交易策略。

## 风险提示

⚠️ **重要提示**：
- 全仓模式风险较高，请确保您理解其运作机制
- 建议新手从逐仓模式开始
- 无论选择哪种模式，都要设置合理的杠杆倍数
- 定期监控账户状态，及时调整策略

## 相关文档

- [杠杆设置指南](leverage-settings.md)
- [交易币种配置](trading-symbols.md)
- [风险管理最佳实践](../best-practices/risk-management.md)
